# Title: HEXT Editor - Text To ASCII Banner Script
# Version: 1.3.0
# Author: K0NxT3D
import os
import pyfiglet
import sys

def clear_screen():
    os.system('cls' if os.name == 'nt' else 'clear')

def display_options():
    print("\n0: Exit")
    print("1: Save and Exit")
    print("2: Save and Continue")
    print("3: Continue without Saving")

def generate_banner(text, style):
    return pyfiglet.figlet_format(text, font=style)

def main():
    styles = pyfiglet.FigletFont.getFonts()
    
    while True:
        clear_screen()
        text = input("Enter the text for your banner: ")
        
        current_style_index = 0
        while True:
            clear_screen()
            
            # Get the current style and preview the banner
            style = styles[current_style_index]
            preview = generate_banner(text, style)
            print(f"Style: {style}")
            print(preview)
            
            # Display options
            display_options()
            
            # Ask if the user likes the current style
            user_choice = input(f"Choose an option (Style: {style}): ").strip().lower()
            
            if user_choice == '0':
                sys.exit()  # Exit if the user selects '0'
            elif user_choice == '1':
                filename = input("Enter filename to save (with .txt extension): ")
                with open(filename, 'w') as file:
                    file.write(preview)
                print(f"Banner saved as {filename}")
                input("Press Enter to exit...")
                break  # Exit after saving
            elif user_choice == '2':
                filename = input("Enter filename to save (with .txt extension): ")
                with open(filename, 'w') as file:
                    file.write(preview)
                print(f"Banner saved as {filename}")
                input("Press Enter to continue...")  # Save and continue to next style
                current_style_index += 1
                if current_style_index >= len(styles):
                    print("No more styles left.")
                    break
            elif user_choice == '3':
                # Just continue without saving
                current_style_index += 1
                if current_style_index >= len(styles):
                    print("No more styles left.")
                    break
            elif user_choice == 'n':
                # Move to the next style if 'n' is chosen
                current_style_index += 1
                if current_style_index >= len(styles):
                    print("No more styles left.")
                    break
            else:
                print("Invalid choice. Please choose '0', '1', '2', '3', or 'n'.")
                
if __name__ == "__main__":
    main()

